#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Ripples on a sphereMod01.fsh  by  rucksack   
//https://www.shadertoy.com/view/7ljcRG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// For easily pasting this into a project I'm working on
#define time iTime

// Raymarching parameters
#define MAX_STEPS 300
#define NEAR_ENOUGH 0.001
#define TOO_FAR 20.0
#define NORMAL_DELTA 0.001

// Lighting parameters
#define DIFFUSE_FACTOR 1.
#define SPECULAR_FACTOR .2
#define SHININESS 8.

#define BACKGROUND_COLOR vec3(0., 0., 0.)
#define SURFACE_COLOR vec3(0.76471,0.78039,0.78039)
#define BLOOM_COLOR vec3(0.84314,0.67843,0.39216)

// Parameters
#define SMOOTH_FACTOR 0.3
#define BLOOM_STEP 0.04

float sphere(vec3 point, vec3 center, float radius) {
    return length(point - center) - radius;
}

float distance_from_everything(vec3 point) {
    // Base sphere
    float s = sphere(point, vec3(0, 0, 2.), 3.);
    // Add some ripples
    s += sin(20.* point.x * (cos(time)*.5+.5)) * sin(1. * point.z) * .1;
    return s;
}

float ray_march(vec3 ray_origin, vec3 ray_direction, out int steps) {
    // How far we've traveled
    float d = 0.0;
    steps = 0;
    for (int i = 0; i < MAX_STEPS; i++) {
        // Where we stand
        vec3 point = ray_origin + ray_direction*d;
        // How far anything is from us
        float current_distance = distance_from_everything(point);
        // March on
        d += current_distance;
        steps++;
        // Check status - have we reached a surface?
        if (current_distance < NEAR_ENOUGH || d > TOO_FAR)
            break;
    }
    return d;
}

// See https://iquilezles.org/articles/normalsSDF
vec3 estimate_normal(vec3 point) {
    vec2 e = vec2(NORMAL_DELTA, 0); // x smol, y none
    // Find normal as tangent of distance function
    return normalize(vec3(
        distance_from_everything(point + e.xyy) - distance_from_everything(point - e.xyy),
        distance_from_everything(point + e.yxy) - distance_from_everything(point - e.yxy),
        distance_from_everything(point + e.yyx) - distance_from_everything(point - e.yyx)
    ));
}

float phong_light(vec3 point, vec3 light_position, vec3 n, vec3 camera) {
    vec3 l = normalize(light_position-point);
    vec3 c = normalize(camera-point);
    float diffuse = max(dot(n, l), 0.);
    float specular = pow(max(dot(reflect(-l, n), c), 0.), SHININESS);

    return DIFFUSE_FACTOR * diffuse + SPECULAR_FACTOR * specular;
}

vec3 lighting(vec3 point, vec3 camera, vec3 ray_direction, float dist, int steps) {
    // Avoid casting specular highlight from the void
    // (and blend in bloom)
    float bloom = .7* BLOOM_STEP * float(steps + 10);
    if (length(point - camera) > TOO_FAR*0.99)
        return BACKGROUND_COLOR + bloom * BLOOM_COLOR;

    float phong = phong_light(point, vec3(1, 1, -2), estimate_normal(point), camera);
    // Basic attempt at ambient occlusion
    phong = phong * smoothstep(4., 0., float(steps)/10.);
    return phong * SURFACE_COLOR + .7*sqrt(bloom) * BLOOM_COLOR;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 xy = (fragCoord - 0.5*iResolution.xy) / iResolution.y;

    // Ray origin
    vec3 camera = vec3(0., 0, -4.);
    // Ray direction
    vec3 ray_direction = vec3(xy, 1.);

    int steps;
    float d = ray_march(camera, ray_direction, steps);
    
    vec3 point = camera + ray_direction * d;
    
    vec3 base_color = lighting(point, camera, ray_direction, d, steps);

    fragColor = vec4(base_color, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

